/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import choco.kernel.common.IIndex;
import choco.kernel.common.util.iterators.ArrayIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import gnu.trove.TLongIntHashMap;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class DeterministicIndicedList<O extends IIndex>
implements Serializable {
    private final Class clazz;
    private final TLongIntHashMap indices;
    private O[] objects;
    private int last;

    public DeterministicIndicedList(Class clazz, int initialSize) {
        this.clazz = clazz;
        this.indices = new TLongIntHashMap(initialSize);
        this.objects = (IIndex[])Array.newInstance(clazz, initialSize);
        this.last = 0;
    }

    public DeterministicIndicedList(Class clazz) {
        this(clazz, 32);
    }

    public void clear() {
        this.indices.clear();
        Arrays.fill(this.objects, null);
        this.objects = null;
    }

    public void add(O object) {
        if (!this.indices.containsKey(object.getIndex())) {
            this.ensureCapacity();
            this.objects[this.last] = object;
            this.indices.put(object.getIndex(), this.last++);
        }
    }

    private void ensureCapacity() {
        if (this.last >= this.objects.length) {
            int cindT = this.objects.length * 3 / 2 + 1;
            O[] oldObjects = this.objects;
            this.objects = (IIndex[])Array.newInstance(this.clazz, cindT);
            System.arraycopy(oldObjects, 0, this.objects, 0, this.last);
        }
    }

    public int remove(O object) {
        if (this.indices.containsKey(object.getIndex())) {
            int ind = this.indices.get(object.getIndex());
            this.indices.remove(object.getIndex());
            if (this.last > 0 && ind < this.last - 1) {
                this.objects[ind] = this.objects[this.last - 1];
                this.indices.adjustValue(this.objects[ind].getIndex(), -this.last + ind + 1);
            }
            this.objects[--this.last] = null;
            return ind;
        }
        return -1;
    }

    public boolean contains(O object) {
        return this.indices.containsKey(object.getIndex());
    }

    public int size() {
        return this.last;
    }

    public O get(int i) {
        return this.objects[i];
    }

    public int get(O object) {
        return this.indices.get(object.getIndex());
    }

    public O getLast() {
        if (this.last > 0) {
            return this.objects[this.last - 1];
        }
        return null;
    }

    public DisposableIterator<O> iterator() {
        return ArrayIterator.getIterator(this.objects, this.last);
    }
}

