/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.Value;

public class FieldUtil {
    private FieldUtil() {
    }

    public static <F extends Field<F>> List<?> getValues(F field) {
        return FieldUtil.getValues(field, null);
    }

    public static <F extends Field<F>> List<?> getValues(F field, Value.Property property) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (property == null) {
            property = Value.Property.VALID;
        }
        List pmmlValues = ((HasDiscreteDomain)field).getValues();
        for (Value pmmlValue : pmmlValues) {
            if (property != pmmlValue.getProperty()) continue;
            result.add(pmmlValue.requireValue());
        }
        return result;
    }

    public static <F extends Field<F>> void addValues(F field, List<?> values) {
        FieldUtil.addValues(field, null, values);
    }

    public static <F extends Field<F>> void addValues(F field, Value.Property property, List<?> values) {
        if (property == Value.Property.VALID) {
            property = null;
        }
        List pmmlValues = ((HasDiscreteDomain)field).getValues();
        for (Object value : values) {
            Value pmmlValue = new Value(value).setProperty(property);
            pmmlValues.add(pmmlValue);
        }
    }

    public static <F extends Field<F>> void clearValues(F field, Value.Property property) {
        if (property == null) {
            property = Value.Property.VALID;
        }
        List pmmlValues = ((HasDiscreteDomain)field).getValues();
        Iterator it = pmmlValues.iterator();
        while (it.hasNext()) {
            Value pmmlValue = (Value)it.next();
            if (pmmlValue.getProperty() != property) continue;
            it.remove();
        }
    }
}

