/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.MsrTable;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.X11Kernel;
import jdplus.x13.base.core.x11.filter.X11FilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.FilteredMeanEndPoints;

public class MsrFilterSelection {
    private static final double[] C = new double[]{1.0, 1.02584, 1.01779, 1.01383, 1.0, 3.0, 1.55291, 1.30095};
    private DoubleSeq seas;
    private DoubleSeq irr;
    private MsrTable msrTable;
    private double msr;
    private int iter;
    private boolean useDefault;

    public MsrTable getMsrTable() {
        return this.msrTable;
    }

    public double getGlobalMsr() {
        return this.msr;
    }

    public int getIterCount() {
        return this.iter;
    }

    public boolean isUsingDefault() {
        return this.useDefault;
    }

    public SeasonalFilterOption doMSR(DoubleSeq data, X11Context context) {
        SeasonalFilterOption seasFilter = null;
        int nf = context.getForecastHorizon();
        int nb = context.getBackcastHorizon();
        DoubleSeq series = data.drop(nb, nf);
        series = this.completeYear(series, context);
        this.useDefault = true;
        this.iter = 0;
        this.msr = 0.0;
        while (series.length() / context.getPeriod() >= 5) {
            ++this.iter;
            this.calcComponents(series, context);
            this.msrTable = MsrTable.of((DoubleSeq)this.seas, (DoubleSeq)this.irr, (int)context.getPeriod(), (int)context.getPosition(nb), (context.getMode() == DecompositionMode.Multiplicative ? 1 : 0) != 0);
            this.msr = this.msrTable.getGlobalMsr();
            seasFilter = this.decideFilter(this.msr);
            if (seasFilter != null) break;
            series = series.drop(0, context.getPeriod());
        }
        if (seasFilter == null) {
            seasFilter = SeasonalFilterOption.S3X5;
        } else {
            this.useDefault = false;
        }
        return seasFilter;
    }

    private DoubleSeq completeYear(DoubleSeq series, X11Context context) {
        int start = context.getPosition(context.getBackcastHorizon());
        int period = context.getPeriod();
        int ecut = (series.length() + start) % period;
        int bcut = 0;
        return series.drop(bcut, ecut);
    }

    private void calcComponents(DoubleSeq series, X11Context context) {
        SymmetricFilter filter = X11FilterFactory.makeSymmetricFilter(7);
        FilteredMeanEndPoints f = new FilteredMeanEndPoints(filter);
        double[] x = X11Kernel.table(series.length(), Double.NaN);
        DataBlock out = DataBlock.of((double[])x);
        for (int j = 0; j < context.getPeriod(); ++j) {
            DataBlock bin = DataBlock.of((DoubleSeq)series).extract(j, -1, context.getPeriod());
            DataBlock bout = out.extract(j, -1, context.getPeriod());
            f.process((DoubleSeq)bin, bout);
        }
        this.seas = out;
        this.irr = this.calcIrregular(context, series, this.seas);
    }

    protected DoubleSeq calcIrregular(X11Context context, DoubleSeq series, DoubleSeq seas) {
        return context.remove(series, seas);
    }

    private SeasonalFilterOption decideFilter(double msr) {
        if (msr < 2.5) {
            return SeasonalFilterOption.S3X3;
        }
        if (msr >= 2.5 && msr < 3.5) {
            return null;
        }
        if (msr >= 3.5 && msr < 5.5) {
            return SeasonalFilterOption.S3X5;
        }
        if (msr >= 5.5 && msr < 6.5) {
            return null;
        }
        return SeasonalFilterOption.S3X9;
    }
}

