/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class TreeSpaceLogger {
    private String[] trees;
    private int[] islands;
    private int[][] transitions;
    private int[][] steps;
    private int[][] islandTransitions;
    private int[] islandDwellTimes;
    private String lastKnownTree;
    private List<String> currentPath;

    public TreeSpaceLogger(String string) {
        this.readTrees(string);
        this.currentPath = new ArrayList<String>();
    }

    private void readTrees(String string) {
        try {
            Tree tree;
            String string2;
            FileReader fileReader = new FileReader(new File(string));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\s++");
                NewickImporter newickImporter = new NewickImporter(string2);
                tree = newickImporter.importNextTree();
                arrayList.add(tree);
                arrayList2.add(Integer.parseInt(stringArray[0]));
            }
            bufferedReader.close();
            fileReader.close();
            this.trees = new String[arrayList.size()];
            this.islands = new int[arrayList.size()];
            int n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3;
                tree = (Tree)arrayList.get(i);
                this.trees[i] = string3 = TreeUtils.uniqueNewick(tree, tree.getRoot());
                this.islands[i] = (Integer)arrayList2.get(i) - 1;
                if ((Integer)arrayList2.get(i) <= n) continue;
                n = (Integer)arrayList2.get(i);
            }
            this.transitions = new int[arrayList.size()][arrayList.size()];
            this.steps = new int[arrayList.size()][arrayList.size()];
            this.islandTransitions = new int[n][n];
            this.islandDwellTimes = new int[n];
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Importer.ImportException importException) {
            importException.printStackTrace();
        }
    }

    public void log(Tree tree) {
        String string = TreeUtils.uniqueNewick(tree, tree.getRoot());
        if (this.lastKnownTree == null || this.lastKnownTree.equals("")) {
            int n = this.findTree(string);
            if (n != -1) {
                this.lastKnownTree = string;
            }
        } else if (string.equals(this.lastKnownTree)) {
            if (this.currentPath.size() >= 1) {
                int n = this.findTree(this.lastKnownTree);
                int[] nArray = this.transitions[n];
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                int[] nArray2 = this.steps[n];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + this.currentPath.size();
                int[] nArray3 = this.islandTransitions[this.islands[n]];
                int n4 = this.islands[n];
                nArray3[n4] = nArray3[n4] + 1;
                int n5 = this.islands[n];
                this.islandDwellTimes[n5] = this.islandDwellTimes[n5] + this.currentPath.size();
            }
            this.currentPath.clear();
        } else {
            int n = this.findTree(string);
            if (n == -1) {
                this.currentPath.add(string);
            } else {
                this.currentPath.add(string);
                int n6 = this.findTree(this.lastKnownTree);
                int[] nArray = this.transitions[n6];
                int n7 = n;
                nArray[n7] = nArray[n7] + 1;
                int[] nArray4 = this.steps[n6];
                int n8 = n;
                nArray4[n8] = nArray4[n8] + (this.currentPath.size() - 1);
                int n9 = this.islands[n];
                this.islandDwellTimes[n9] = this.islandDwellTimes[n9] + (this.currentPath.size() - 1);
                int[] nArray5 = this.islandTransitions[this.islands[n6]];
                int n10 = this.islands[n];
                nArray5[n10] = nArray5[n10] + 1;
                this.currentPath.clear();
                this.lastKnownTree = string;
            }
        }
    }

    private int findTree(String string) {
        for (int i = 0; i < this.trees.length; ++i) {
            if (!this.trees[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void printTransitionMatrix() {
        System.out.println("\n\nPrint transition matrix:\n");
        for (int i = 0; i < this.trees.length; ++i) {
            for (int j = 0; j < this.trees.length; ++j) {
                System.out.print(this.transitions[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public void printIslandTransitionMatrix() {
        System.out.println("\n\nPrint island transition matrix:\n");
        for (int i = 0; i < this.islandTransitions.length; ++i) {
            for (int j = 0; j < this.islandTransitions.length; ++j) {
                System.out.print(this.islandTransitions[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public void printMeanTopologyMatrix() {
        System.out.println("\n\nPrint mean # of topologies on path matrix:\n");
        for (int i = 0; i < this.trees.length; ++i) {
            for (int j = 0; j < this.trees.length; ++j) {
                int n = this.transitions[i][j];
                if (n == 0) {
                    n = 1;
                }
                System.out.print(this.steps[i][j] / n + "\t");
            }
            System.out.println();
        }
    }

    public void printIslandDwellMatrix() {
        System.out.println("\n\nPrint mean dwell time matrix:\n");
        for (int i = 0; i < this.islandDwellTimes.length; ++i) {
            int n = 0;
            for (int j = 0; j < this.islandDwellTimes.length; ++j) {
                if (i == j) continue;
                n += this.islandTransitions[i][j];
            }
            if (n == 0) {
                n = 1;
            }
            System.out.print(this.islandDwellTimes[i] / n + "\t");
            System.out.println();
        }
    }

    public void finishLogging() {
        this.printTransitionMatrix();
        this.printIslandTransitionMatrix();
        this.printMeanTopologyMatrix();
        this.printIslandDwellMatrix();
    }

    public static void main(String[] stringArray) {
        TreeSpaceLogger treeSpaceLogger = new TreeSpaceLogger("DS1_Treespace.trees");
        treeSpaceLogger.finishLogging();
    }
}

