/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import ch.randelshofer.quaqua.util.Images;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;

public class OSXImageIO {
    private static int EXPECTED_NATIVE_CODE_VERSION = 1;
    private static volatile Boolean isNativeCodeAvailable;

    private OSXImageIO() {
    }

    public static BufferedImage read(File file) throws IOException {
        if (!OSXImageIO.isNativeCodeAvailable()) {
            throw new IOException("Native code is not available");
        }
        byte[] tiffData = OSXImageIO.nativeRead(file.getPath());
        if (tiffData == null) {
            throw new IOException("Couldn't read image from file " + file);
        }
        return OSXImageIO.decodeTIFF(tiffData);
    }

    public static BufferedImage read(File file, int width, int height) throws IOException {
        if (!OSXImageIO.isNativeCodeAvailable()) {
            throw new IOException("Native code is not available");
        }
        byte[] tiffData = OSXImageIO.nativeRead(file.getPath(), width, height);
        if (tiffData == null) {
            throw new IOException("Couldn't read image from file " + file);
        }
        return OSXImageIO.decodeTIFF(tiffData);
    }

    public static BufferedImage read(byte[] data) throws IOException {
        if (!OSXImageIO.isNativeCodeAvailable()) {
            throw new IOException("Native code is not available");
        }
        byte[] tiffData = OSXImageIO.nativeRead(data);
        if (tiffData == null) {
            throw new IOException("Couldn't read image from data array");
        }
        return OSXImageIO.decodeTIFF(tiffData);
    }

    public static BufferedImage readSystemClipboard() throws IOException {
        if (!OSXImageIO.isNativeCodeAvailable()) {
            throw new IOException("Native code is not available");
        }
        byte[] tiffData = OSXImageIO.nativeReadSystemClipboard();
        if (tiffData == null) {
            throw new IOException("Couldn't read an image from the clipboard");
        }
        return OSXImageIO.decodeTIFF(tiffData);
    }

    private static BufferedImage decodeTIFF(byte[] tiffData) throws IOException {
        TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
        RenderedImage rImg = decoder.decodeAsRenderedImage(0);
        return Images.toBufferedImage(rImg);
    }

    private static native byte[] nativeRead(String var0);

    private static native byte[] nativeRead(String var0, int var1, int var2);

    private static native byte[] nativeRead(byte[] var0);

    private static native byte[] nativeReadSystemClipboard();

    private static native int nativeGetNativeCodeVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            block18: {
                Class<OSXImageIO> clazz = OSXImageIO.class;
                // MONITORENTER : ch.randelshofer.quaqua.osx.OSXImageIO.class
                if (isNativeCodeAvailable == null) {
                    boolean success = false;
                    try {
                        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                        if (value == null) {
                            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                        }
                        String libraryName = null;
                        if (value != null && value.equals("true")) {
                            success = true;
                        } else {
                            String osArch = System.getProperty("os.arch");
                            String[] libraryNames = osArch.equals("x86_64") ? new String[]{"quaqua64"} : new String[]{"quaqua64", "quaqua"};
                            for (int i = 0; i < libraryNames.length; ++i) {
                                libraryName = libraryNames[i];
                                try {
                                    System.loadLibrary(libraryName);
                                    success = true;
                                    break;
                                }
                                catch (UnsatisfiedLinkError e) {
                                    System.err.println("Warning: " + OSXImageIO.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                    continue;
                                }
                                catch (AccessControlException e) {
                                    System.err.println("Warning: " + OSXImageIO.class + " access controller denied loading library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                    continue;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    System.err.println("Warning: " + OSXImageIO.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                    success = false;
                                }
                            }
                        }
                        if (!success) break block18;
                        try {
                            int nativeCodeVersion = OSXImageIO.nativeGetNativeCodeVersion();
                            if (nativeCodeVersion != EXPECTED_NATIVE_CODE_VERSION) {
                                System.err.println("Warning: " + OSXImageIO.class + " can't use library " + libraryName + ". It has version " + nativeCodeVersion + " instead of " + EXPECTED_NATIVE_CODE_VERSION);
                                success = false;
                            }
                        }
                        catch (UnsatisfiedLinkError e) {
                            System.err.println("Warning: " + OSXImageIO.class + " could load library " + libraryName + " but can't use it. " + e);
                            success = false;
                        }
                    }
                    finally {
                        isNativeCodeAvailable = success;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (isNativeCodeAvailable != Boolean.TRUE) return false;
        return true;
    }
}

