# coenocliner 0.2-4

* Fixes due to deprecations in *testthat*

* Updated some of the package infrastructure to be more modern

# coenocliner 0.2-3

* Fix an issue causing vignette compiling to fail due to an update to the
  LaTeX package *hyperref*. Reported by: Brian Ripley.

# coenocliner 0.2-2

* `NegBin()` and `ZINB()` incorrectly specified the gamma part of the
  distribution. The `shape` argument to `rgamma()` should have been
  `1/alpha` where `alpha` was used previously.

    Also clarified the parameterisation of the negative binomial used
    by `NegBin()` and `ZINB` as the NB2 version.

* `NegBin()` and `ZINB()` allow for vector `alpha` inputs. #25

# coenocliner 0.2-1

* Minor package update to fix issues under `R CMD check` in the
  development version of R.

# coenocliner 0.2-0

* Jari Oksanen is now listed as a contributor to the package having
  added several new stochastic distributions.

* The object returned by `coenocline()` now has S3 class `"coenocline"`
  and inherits from the `"matrix"` class.

* A `print()` method has been added for `coenocline()` which displays
  some summary information and the first `n` lines of the simulated
  counts. The `print()` method uses a new internal function modelled
  on the way **dplyr** prints data frames.

* A `stack()` method for `coenocline()` was added. This makes it much
  easier to reshape the simulated count data into a format suitable for
  use with **ggplot** or **lattice** graphics, or R's modelling
  functions.

* An enhanced `plot()` method for `coenocline()` objects is provided,
  which can draw 1-d plots of single gradient simulations.

* A `persp()` method is now provided which can produced 3-d perspective
  plots of simulations with 2 gradients.

* Two new stochastic distributions were added by Jari Oksanen

    - Zero-inflated Binomial
    - Zero-inflated Beta-binomial

* A new extractor function is provided, `locations()`, which extracts
  the gradient locations at which counts were simulated.

## Bug fixes

* Jari Oksanen noticed an annoying but important bug in the 2D Beta
  response function; the `gamma` parameter for the second gradient
  was being ignored, and the value of `gamma` for the first gradient
  was used instead.

# coenocliner 0.1-0

* An R package for coenocline simulation; generating simulated species
  abundance or occurrence data along one or two gradients

* First public release of coenocliner on CRAN

* Species response can be parameterised using either the classic
  Gaussian response model or the generalise beta response model

* Random count or occurrence data can be simulated from species
  responses using random draws from a Poisson, Negative Binomial,
  Binomial, Beta-binomial, ZIP, ZINB, or Bernoulli distribution with
  the parameterised response curve taken as the mean or expectation of
  the distribution to draw from

* The main user-facing function is `coenocline()`. See `?coenocliner`
  and `?coenocline` for further details and examples of usage

* A basic overview and introductory tutorial for coenocliner is available.
  Run `browseVignettes("coenocliner")` in R to access the PDF, R code and
  sources.