/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.DStatException;

public class SpecialFunctions {
    private static final double[] c_gammaconst = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static final double EPS = 1.0E-16;
    private static final double c_sqrt2 = Math.sqrt(2.0);
    private static final double c_log2 = Math.log(2.0);
    private static int m_maxiter = 1000;

    public static double beta(double x, double y) {
        return SpecialFunctions.gamma(x) * SpecialFunctions.gamma(y) / SpecialFunctions.gamma(x + y);
    }

    public static double Beta_Density(double x, double a, double b) {
        double bb = SpecialFunctions.logGamma(a + b) - SpecialFunctions.logGamma(a) - SpecialFunctions.logGamma(b);
        return Math.exp(bb + (a - 1.0) * Math.log(x) + (b - 1.0) * Math.log(1.0 - x));
    }

    public static double binomialDensity(double n, double k, double p) {
        return Math.exp(SpecialFunctions.logGamma(n + 1.0) - SpecialFunctions.logGamma(k + 1.0) - SpecialFunctions.logGamma(n - k + 1.0) + k * Math.log(p) + (n - k) * Math.log(1.0 - p));
    }

    public static double chiSquare(double chi, double v) {
        if (chi < 0.0) {
            throw new DStatException("chi value must be strictly positive", "SpecialFunctions.ChiSquare");
        }
        return SpecialFunctions.incGamma(v / 2.0, chi / 2.0);
    }

    public static double chiSquareComplement(double chi, double v) {
        if (chi < 0.0) {
            throw new DStatException("chi value must be strictly positive", "SpecialFunctions.ChiSquareComplement");
        }
        return SpecialFunctions.CIncGamma(v / 2.0, chi / 2.0);
    }

    public static double chiSquareDensity(double x, double v) {
        double gl = SpecialFunctions.logGamma(v / 2.0);
        return Math.exp((v - 2.0) / 2.0 * Math.log(x) - x / 2.0 - v / 2.0 * c_log2 - gl);
    }

    public static double CIncGamma(double a, double x) {
        if (x < a + 1.0) {
            return 1.0 - SpecialFunctions.IGSeries(a, x);
        }
        return SpecialFunctions.IGContFract(a, x);
    }

    public static double cumBinomial(double n, double k, double p) {
        if (k == 0.0) {
            return 1.0;
        }
        return SpecialFunctions.incBeta(k, n - k + 1.0, p);
    }

    public static double cumulativePoisson(double x, double lambda) {
        if (x < 0.0 || lambda < 1.0) {
            throw new DStatException("x must be positive and lambda must be >= 1", "SpecialFunctions.CumulativePoisson");
        }
        return SpecialFunctions.CIncGamma(lambda, x);
    }

    public static double errorF(double x) {
        if (x < 0.0) {
            return -1.0 * SpecialFunctions.incGamma(0.5, x * x);
        }
        return SpecialFunctions.incGamma(0.5, x * x);
    }

    public static double FDensity(double val, double k1, double k2) {
        return Math.exp(SpecialFunctions.logGamma((k1 + k2) / 2.0) - SpecialFunctions.logGamma(k1 / 2.0) - SpecialFunctions.logGamma(k2 / 2.0) + k1 / 2.0 * Math.log(k1 / k2) + (k1 - 2.0) / 2.0 * Math.log(val) - (k1 + k2) / 2.0 * Math.log(1.0 + k1 / k2 * val));
    }

    public static double FProbability(double val, double df1, double df2) {
        return SpecialFunctions.incBeta(df2 / 2.0, df1 / 2.0, df2 / (df2 + df1 * val));
    }

    public static double gamma(double x) {
        double e1 = x + 5.5;
        double ep = Math.pow(e1, x + 0.5);
        double t = Math.exp(-e1);
        double series = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            series += c_gammaconst[i] / (x + (double)(i + 1));
        }
        series *= 2.5066282746310007;
        series *= ep;
        return (series *= t) / x;
    }

    public static double gammaDensity(double x, double a, double b) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.exp((a - 1.0) * Math.log(x) - x / b - a * Math.log(b) - SpecialFunctions.logGamma(a));
    }

    public static int getMaxIter() {
        return m_maxiter;
    }

    public static double hyperGeometricDensity(double n, double m, double l, double k) {
        if (!(0.0 <= l) || !(l <= n)) {
            throw new DStatException("Population and sample size must be positive and sample size cannot be larger than population size", "SpecialFunctions.HyperGeometricDensity");
        }
        if (!(Math.max(0.0, l - (n - m)) <= k) || !(k <= Math.min(l, m))) {
            throw new DStatException("k must satisfy max(0, l-(n-m)) <= k <= min(l, m)", "SpecialFunctions.HyperGeometricDensity");
        }
        return Math.exp(SpecialFunctions.logGamma(m + 1.0) + SpecialFunctions.logGamma(n - m + 1.0) + SpecialFunctions.logGamma(l + 1.0) + SpecialFunctions.logGamma(n - l + 1.0) - SpecialFunctions.logGamma(k + 1.0) - SpecialFunctions.logGamma(m - k + 1.0) - SpecialFunctions.logGamma(l - k + 1.0) - SpecialFunctions.logGamma(n - m - l + k + 1.0) - SpecialFunctions.logGamma(n + 1.0));
    }

    public static double hyperGeometricProbability(double n, double m, double l, double k) {
        if (!(0.0 <= l) || !(l <= n)) {
            throw new DStatException("Population and sample size must be positive and sample size cannot be larger than population size", "SpecialFunctions.HyperGeometricProbability");
        }
        if (!(Math.max(0.0, l - (n - m)) <= k) || !(k <= Math.min(l, m))) {
            throw new DStatException("k must satisfy max(0, l-(n-m)) <= k <= min(l, m)", "SpecialFunctions.HyperGeometricProbability");
        }
        double lm = Math.min(l, m);
        if (k == lm) {
            return 1.0;
        }
        if (k < lm / 2.0) {
            double hout = SpecialFunctions.hyperGeometricDensity(n, m, l, 0.0);
            int i = 1;
            while ((double)i <= k) {
                hout += hout * ((m - k + 1.0) * (l - k + 1.0)) / (k * (n - m - l + k));
                ++i;
            }
            return hout;
        }
        double hout = SpecialFunctions.hyperGeometricDensity(n, m, l, lm);
        for (int i = (int)lm - 1; i > (int)k; --i) {
            hout += hout / ((m - k + 1.0) * (l - k + 1.0)) / (k * (n - m - l + k));
        }
        return 1.0 - hout;
    }

    static double IGContFract(double a, double x) {
        double d;
        if (a <= 0.0 || x < 0.0) {
            throw new DStatException("Wrong parameter values: use a > 0 and x >= 0", "SpecialFunctions.IGContFract");
        }
        double FPMIN = 1.0E-65;
        double b = x + 1.0 - a;
        double c = 1.0 / FPMIN;
        double h = d = 1.0 / b;
        boolean stopped = false;
        for (int i = 1; i < m_maxiter; ++i) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = b + an / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (!(Math.abs(del - 1.0) <= 1.0E-16)) continue;
            stopped = true;
            break;
        }
        if (!stopped) {
            throw new DStatException("Too many iterations in search procedure", "SpecialFunctions.IGContFract");
        }
        double ga = SpecialFunctions.logGamma(a);
        double dout = Math.exp(-x + a * Math.log(x) - ga) * h;
        return dout;
    }

    static double IGSeries(double a, double x) {
        double div;
        if (a <= 0.0 || x < 0.0) {
            throw new DStatException("Wrong parameter values: use a > 0 and x >= 0", "SpecialFunctions.IGSeries");
        }
        double sum = div = 1.0 / a;
        double aa = a;
        for (int i = 0; i < m_maxiter; ++i) {
            sum += (div *= x / (aa += 1.0));
            if (!(Math.abs(div) < Math.abs(sum) * 1.0E-16)) continue;
            double gser = sum * Math.exp(-x + a * Math.log(x) - SpecialFunctions.logGamma(a));
            return gser;
        }
        throw new DStatException("Too many iterations in search procedure", "SpecialFunctions.IGSeries");
    }

    public static double incBeta(double a, double b, double x) {
        if (a < 0.0 || b < 0.0) {
            throw new DStatException("Parameters a and b must be strictly positive", "SpecialFunctions.IncBeta");
        }
        if (x < 0.0 || x > 1.0) {
            throw new DStatException("Parameter x must be between 0 and 1 inclusive", "SpecialFunctions.IncBeta");
        }
        double corr = 0.0;
        corr = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(SpecialFunctions.logGamma(a + b) - SpecialFunctions.logGamma(a) - SpecialFunctions.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return corr * SpecialFunctions.incBetaCf(a, b, x) / a;
        }
        return 1.0 - corr * SpecialFunctions.incBetaCf(b, a, 1.0 - x) / b;
    }

    static double incBetaCf(double a, double b, double x) {
        double FPMIN = 1.0E-65;
        double am1 = a - 1.0;
        double ap1 = a + 1.0;
        double apb = a + b;
        double c = 1.0;
        double d = 1.0 - apb * x / ap1;
        if (Math.abs(d) < FPMIN) {
            d = FPMIN;
        }
        double h = d = 1.0 / d;
        boolean stopped = false;
        for (int i = 1; i < m_maxiter; ++i) {
            double m2 = i * 2;
            double aa = (double)i * (b - (double)i) * x / ((am1 + m2) * (a + m2));
            if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            h *= c * d;
            aa = -(a + (double)i) * (apb + (double)i) * x / ((a + m2) * (ap1 + m2));
            if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = c * d;
            h *= del;
            if (!(Math.abs(del - 1.0) < 1.0E-16)) continue;
            stopped = true;
            break;
        }
        if (!stopped) {
            throw new DStatException("Too many iterations in search procedure", "SpecialFunctions.IncBetaCf");
        }
        return h;
    }

    public static double incGamma(double a, double x) {
        if (x < a + 1.0) {
            return SpecialFunctions.IGSeries(a, x);
        }
        return 1.0 - SpecialFunctions.IGContFract(a, x);
    }

    public static double logGamma(double x) {
        if (x <= 0.0) {
            throw new DStatException("Invalid argument to LogGamma - must be > 0.0", "SpecialFunctions.LogGamma");
        }
        double arg = x + 5.5;
        double t = (x + 0.5) * Math.log(arg) - arg;
        double series = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            series += c_gammaconst[i] / (x + (double)(i + 1));
        }
        series = Math.log(series);
        return (t += (series += Math.log(2.5066282746310007))) - Math.log(x);
    }

    public static double logNormalDensity(double x, double t50, double s) {
        if (x <= 0.0) {
            throw new DStatException("Argument must be larger than 0.0", "SpecialFunctions.LogNormalDensity");
        }
        double larg = Math.log(x);
        double exp = (larg - t50) * (larg - t50) * (-1.0 / (2.0 * s * s));
        double res = Math.exp(exp - Math.log(2.5066282746310007 * s * x));
        return res;
    }

    public static double normalC(double x) {
        return 0.5 * (1.0 - SpecialFunctions.errorF(-x / c_sqrt2));
    }

    public static double normalDensity(double x, double m, double s) {
        double arg = Math.pow((x - m) / s, 2.0) * -0.5;
        return Math.exp(arg - Math.log(s) - Math.log(2.5066282746310007));
    }

    public static double poissonProbability(double x, double lambda) {
        return Math.exp(x * Math.log(lambda) - lambda - SpecialFunctions.logGamma(x + 1.0));
    }

    public static void setMaxIter(int maxIter) {
        m_maxiter = maxIter;
    }

    public static double studentDensity(double val, double df) {
        if (df <= 0.0) {
            throw new DStatException("The T-probability distribution requires df > 0", "SpecialFunctions.StudentDensity");
        }
        return Math.exp(SpecialFunctions.logGamma((df + 1.0) / 2.0) - (df + 1.0) / 2.0 * Math.log(1.0 + val * val / df) - Math.log(Math.sqrt(Math.PI * df)) - SpecialFunctions.logGamma(df / 2.0));
    }

    public static double studentProbability(double val, double df) {
        double bb = SpecialFunctions.incBeta(df / 2.0, 0.5, df / (df + val * val));
        double tm = (1.0 - bb) / 2.0;
        if (val < 0.0) {
            return 0.5 - tm;
        }
        return 0.5 + tm;
    }
}

