/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.ADCComparatorGraphics;
import edsim51di.Board;
import edsim51di.DAC;
import edsim51di.KeypadGraphics;
import edsim51di.Mapping;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class Comparator
extends Peripheral {
    private double OUTPUT = 3.7;
    private int outputPort;
    private int outputPin;
    private ADCComparatorGraphics comparatorGraphics;
    private Board board;
    private KeypadGraphics keypad;

    Comparator(Board board, DAC dac, KeypadGraphics keypad) {
        super("Comparator", false);
        this.board = board;
        this.keypad = keypad;
        double[] d = board.getPortMapSetting("comparator_op");
        if (d != null) {
            this.OUTPUT = d[0];
        }
        this.comparatorGraphics = new ADCComparatorGraphics(board, dac, this);
        this.outputPort = this.getPortNumber(this.OUTPUT);
        this.outputPin = this.getPinNumber(this.OUTPUT);
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[]{new LogicDiagramInterface()};
        interfaces[0].peripheralPin = 690;
        interfaces[0].portNumber = this.outputPort;
        interfaces[0].pinNumber = this.outputPin;
        return interfaces;
    }

    Mapping getOutputMapping() {
        return new Mapping(this.outputPort, this.outputPin, "Comparator Output");
    }

    ADCComparatorGraphics getGraphics() {
        return this.comparatorGraphics;
    }

    void cycle(int dacOutputVoltage) {
        if (this.comparatorGraphics.isADCEnabled() || this.comparatorGraphics.getVoltage() > dacOutputVoltage) {
            this.board.setPortPin(this.outputPort, this.outputPin, 300);
            this.keypad.updateBitByExternalHardware(true, this.outputPort, this.outputPin);
        } else {
            this.board.clearPortPin(this.outputPort, this.outputPin, 300);
            this.keypad.updateBitByExternalHardware(false, this.outputPort, this.outputPin);
        }
    }
}

