/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.logicdiagram;

import edsim51di.logicdiagram.Point;
import java.util.ArrayList;

public class Dots {
    private ArrayList[] dots = new ArrayList[32];

    void addDot(int id, int portNumber, int pinNumber, int x, int y) {
        int index = portNumber * 8 + pinNumber;
        if (this.dots[index] == null) {
            this.dots[index] = new ArrayList();
        }
        this.dots[index].add(new Point(id, x, y));
    }

    void fixDots(int portNumber, int pinNumber, int offset, int step) {
        int numberOfDots = this.getNumberOfDots(portNumber, pinNumber);
        for (int i = 0; i < numberOfDots; ++i) {
            Point p = this.getDot(portNumber, pinNumber, i);
            if (p == null) continue;
            p.x = offset - p.x * step;
        }
    }

    void enableDots(boolean b, int id) {
        for (int pin = 0; pin < 32; ++pin) {
            int numberOfDots = this.getNumberOfDots(pin);
            for (int i = 0; i < numberOfDots; ++i) {
                Point p = this.getDot(pin, i);
                if (p.getId() != id) continue;
                p.enable(b);
            }
        }
    }

    void enableDots(boolean b) {
        for (int pin = 0; pin < 32; ++pin) {
            int numberOfDots = this.getNumberOfDots(pin);
            for (int i = 0; i < numberOfDots; ++i) {
                Point p = this.getDot(pin, i);
                p.enable(b);
            }
        }
    }

    Point getDot(int portNumber, int pinNumber, int dotNumber) {
        int i = portNumber * 8 + pinNumber;
        return this.getDot(i, dotNumber);
    }

    Point getDot(int pin, int dotNumber) {
        if (this.dots[pin] == null) {
            return null;
        }
        return (Point)this.dots[pin].get(dotNumber);
    }

    int getNumberOfDots(int portNumber, int pinNumber) {
        int index = portNumber * 8 + pinNumber;
        return this.getNumberOfDots(index);
    }

    int getNumberOfDots(int pin) {
        if (this.dots[pin] == null) {
            return 0;
        }
        return this.dots[pin].size();
    }
}

