/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Memory;

public class Timer1 {
    private boolean t1;
    private Memory dataMemory;

    Timer1(Memory dataMemory) {
        this.dataMemory = dataMemory;
        this.updateT1();
    }

    private void updateT1() {
        int pin = 0;
        try {
            pin = this.dataMemory.port3.getPortPins();
            pin >>= 5;
            pin &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.t1 = pin == 1;
    }

    public int getMode() {
        int tmod = 0;
        try {
            tmod = this.dataMemory.readByte(137);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmod >> 4 & 3;
    }

    public boolean isRunning() {
        int trBit = 0;
        try {
            trBit = this.dataMemory.getBit(142);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trBit == 1;
    }

    private boolean getGateBit() {
        int gate = 0;
        try {
            gate = this.dataMemory.readByte(137);
            gate >>= 7;
            gate &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gate == 1;
    }

    private boolean getInt1pin() {
        int int1 = 0;
        try {
            int1 = this.dataMemory.port3.getPortPins();
            int1 >>= 3;
            int1 &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return int1 == 1;
    }

    private boolean isCounter() {
        int timerCounter = 0;
        try {
            timerCounter = this.dataMemory.readByte(137);
            timerCounter >>= 6;
            timerCounter &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timerCounter == 1;
    }

    public void step() {
        if (this.getMode() == 3) {
            return;
        }
        boolean tr1 = false;
        boolean gate = false;
        boolean int1 = false;
        try {
            tr1 = this.dataMemory.getBit(142) == 1;
            gate = this.getGateBit();
            int1 = this.getInt1pin();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!tr1 || gate && !int1) {
            return;
        }
        boolean prevT1 = this.t1;
        this.updateT1();
        if (!this.isCounter() || prevT1 && !this.t1) {
            int th1 = 0;
            int tl1 = 0;
            int lowByteOverflowValue = 256;
            boolean tf1 = false;
            try {
                th1 = this.dataMemory.readByte(141);
                tl1 = this.dataMemory.readByte(139);
            }
            catch (Exception exception) {
                // empty catch block
            }
            lowByteOverflowValue = this.getMode() == 0 ? 32 : 256;
            if (++tl1 >= lowByteOverflowValue) {
                if (this.dataMemory.serial.getMode() == 1 || this.dataMemory.serial.getMode() == 3) {
                    this.dataMemory.serial.pulseClock();
                }
                if (this.getMode() == 2) {
                    tl1 = th1;
                    tf1 = true;
                } else {
                    tl1 = 0;
                    if (++th1 == 256) {
                        th1 = 0;
                        if (this.dataMemory.timer0.getMode() != 3) {
                            tf1 = true;
                        }
                    }
                }
            }
            try {
                this.dataMemory.writeByte(141, th1);
                this.dataMemory.writeByte(139, tl1);
                if (tf1) {
                    this.dataMemory.setBit(143);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

