/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.xrl;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.xrl.XrlAaddress;
import edsim51sh.instructions.xrl.XrlAatReg;
import edsim51sh.instructions.xrl.XrlAdata;
import edsim51sh.instructions.xrl.XrlAddressA;
import edsim51sh.instructions.xrl.XrlAddressData;
import edsim51sh.instructions.xrl.XrlAreg;

public class Xrl
extends Instruction {
    public Xrl() {
        this.mneumonic = "XRL";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("XRL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("XRL A,#")) {
                return new XrlAdata();
            }
            if (mneumonic.length() == 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("XRL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new XrlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("XRL A,@R0") || mneumonic.equals("XRL A,@R1")) {
                    return new XrlAatReg(registerNumber);
                }
            }
            return new XrlAaddress();
        }
        if (mneumonic.endsWith(",A")) {
            return new XrlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new XrlAddressData();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

