/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.ports;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.exceptions.BitAddressAccessException;
import edsim51sh.ports.HardwareIdList;

public abstract class Port {
    int address;
    private boolean[] pins = new boolean[8];
    private HardwareIdList[] heldLowHardwareIds = new HardwareIdList[8];
    private Memory memory;
    private boolean timeToUpdateGui = true;

    public Port(Memory memory) {
        this.memory = memory;
    }

    public boolean hardwareSetPortPin(int pinNumber, int hardwareId) {
        this.noLongerHeldLowByThisHardwarweId(pinNumber, hardwareId);
        try {
            if (this.memory.readPortLatch(this.address + pinNumber) == 1 && !this.isHeldLowByHardware(pinNumber)) {
                this.pins[pinNumber] = true;
                return true;
            }
        }
        catch (BitAddressAccessException bitAddressAccessException) {
            // empty catch block
        }
        return false;
    }

    public void hardwareClearPortPin(int pinNumber, int hardwareId) {
        if (hardwareId != -1) {
            this.addHoldingLowHardwareId(pinNumber, hardwareId);
        }
        this.pins[pinNumber] = false;
    }

    public boolean internalSetPortPin(int pinNumber) {
        try {
            if (this.memory.readPortLatch(this.address + pinNumber) == 1 && !this.isHeldLowByHardware(pinNumber)) {
                this.pins[pinNumber] = true;
                return true;
            }
        }
        catch (BitAddressAccessException bitAddressAccessException) {
            // empty catch block
        }
        return false;
    }

    public void internalClearPortPin(int pinNumber) {
        this.pins[pinNumber] = false;
    }

    public void updatePortPins() {
        try {
            for (int i = 0; i < 8; ++i) {
                if (this.isHeldLowByHardware(i)) continue;
                this.pins[i] = this.memory.readPortLatch(this.address + i) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTimeToUpdateGui(boolean b) {
        this.timeToUpdateGui = b;
    }

    public boolean isItTimeToUpdateGui() {
        return this.timeToUpdateGui;
    }

    public int getPortPins() {
        int data = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.pins[i]) continue;
            data += 1 << i;
        }
        return data;
    }

    public void writePort(String data) throws Exception {
        int iData = Text.parseNumericData(data);
        if (iData != 0x1000000) {
            this.memory.writeByte(this.address, iData);
        }
        this.updatePortPins();
    }

    public int getPortPin(int pinNumber) {
        if (pinNumber < 0 || pinNumber > 7) {
            return 0;
        }
        if (this.pins[pinNumber]) {
            return 1;
        }
        return 0;
    }

    public boolean isPortPinHigh(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            return false;
        }
        return this.pins[bitNumber];
    }

    private void addHoldingLowHardwareId(int bitNumber, int id) {
        if (this.heldLowHardwareIds[bitNumber] == null) {
            this.heldLowHardwareIds[bitNumber] = new HardwareIdList();
        }
        this.heldLowHardwareIds[bitNumber].holdLow(id);
    }

    private void noLongerHeldLowByThisHardwarweId(int bitNumber, int id) {
        if (this.heldLowHardwareIds[bitNumber] != null) {
            this.heldLowHardwareIds[bitNumber].letGo(id);
        }
    }

    private boolean isHeldLowByHardware(int bitNumber) {
        return this.heldLowHardwareIds[bitNumber] != null && !this.heldLowHardwareIds[bitNumber].isNotHeldLow();
    }
}

