/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatDiskDataStorage;
import org.apfloat.internal.FloatMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class FloatDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= (long)ctx.getMemoryTreshold()) {
            return new FloatMemoryDataStorage();
        }
        return new FloatDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= ctx.getMaxMemoryBlockSize()) {
            return new FloatMemoryDataStorage();
        }
        return new FloatDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext ctx;
        long size2;
        if (dataStorage instanceof FloatMemoryDataStorage && (size2 = dataStorage.getSize()) > (long)(ctx = ApfloatContext.getContext()).getMemoryTreshold()) {
            FloatDiskDataStorage tmp = new FloatDiskDataStorage();
            tmp.copyFrom(dataStorage);
            dataStorage = tmp;
        }
        return dataStorage;
    }
}

