/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.domain;

import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.domain.pdp.ClusterDomains;
import org.biojava.bio.structure.domain.pdp.CutDomain;
import org.biojava.bio.structure.domain.pdp.CutSites;
import org.biojava.bio.structure.domain.pdp.Domain;
import org.biojava.bio.structure.domain.pdp.GetDistanceMatrix;
import org.biojava.bio.structure.domain.pdp.PDPDistanceMatrix;
import org.biojava.bio.structure.domain.pdp.ShortSegmentRemover;

public class LocalProteinDomainParser {
    private LocalProteinDomainParser() {
    }

    public static List<Domain> suggestDomains(Structure s) throws StructureException {
        Atom[] ca = StructureTools.getAtomCAArray(s);
        return LocalProteinDomainParser.suggestDomains(ca);
    }

    public static List<Domain> suggestDomains(Atom[] ca) throws StructureException {
        GetDistanceMatrix distMaxCalculator = new GetDistanceMatrix();
        PDPDistanceMatrix pdpMatrix = distMaxCalculator.getDistanceMatrix(ca);
        Domain dom = new Domain();
        Chain c = ca[0].getGroup().getChain();
        dom.setId("D" + c.getParent().getPDBCode() + c.getId() + "1");
        dom.setSize(ca.length);
        dom.setNseg(1);
        dom.getSegmentAtPos(0).setFrom(0);
        dom.getSegmentAtPos(0).setTo(ca.length - 1);
        CutSites cutSites = new CutSites();
        CutDomain cutDomain = new CutDomain(ca, pdpMatrix);
        cutDomain.cutDomain(dom, cutSites, pdpMatrix);
        List<Domain> domains = cutDomain.getDomains();
        domains = ClusterDomains.cluster(domains, pdpMatrix);
        ShortSegmentRemover.cleanup(domains);
        return domains;
    }
}

