/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.server.PDBFilter;
import org.biojava.bio.structure.server.PDBInstallation;

public class FlatFileInstallation
implements PDBInstallation {
    public static final Logger logger = Logger.getLogger("org.biojava.bio.structure");
    private File filePath;
    private List<PDBFilter> filters;
    public static final String DEFAULT_INDEX_FILE = "pdbinfo.txt";
    public static final String DEFAUL_CHAIN_FILE = "chaininfo.txt";
    private File indexFile;
    private File chainInfoFile;
    List<PDBHeader> filteredPDBs;
    PDBFileReader reader;
    Iterator<PDBHeader> filterIterator;
    boolean filtersApplied;
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    public FlatFileInstallation(File filePath) {
        if (!filePath.isDirectory()) {
            throw new IllegalArgumentException("the provided path does not point to a directory!");
        }
        this.filters = new ArrayList<PDBFilter>();
        this.filePath = filePath;
        this.indexFile = new File(filePath + File.separator + DEFAULT_INDEX_FILE);
        this.chainInfoFile = new File(filePath + File.separator + DEFAUL_CHAIN_FILE);
        this.filtersApplied = false;
        this.filteredPDBs = new ArrayList<PDBHeader>();
        this.filterIterator = null;
        this.reader = new PDBFileReader();
        this.reader.setPath(filePath.toString());
    }

    public File getPDBInfoFile() {
        return this.indexFile;
    }

    public void setPDBInfoFile(File indexFile) {
        this.indexFile = indexFile;
    }

    public File getChainInfoFile() {
        return this.chainInfoFile;
    }

    public void setChainInfoFile(File chainInfoFile) {
        this.chainInfoFile = chainInfoFile;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
        this.reader.setPath(filePath.toString());
    }

    @Override
    public void addPDBFilter(PDBFilter filter2) {
        this.filters.add(filter2);
    }

    @Override
    public void clearFilters() {
        this.filters.clear();
    }

    public void applyFilters() {
        this.filteredPDBs.clear();
        try {
            FileInputStream in = new FileInputStream(this.indexFile);
            BufferedReader indexReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            line = indexReader.readLine();
            while (line != null) {
                if (line.startsWith("//")) {
                    line = indexReader.readLine();
                    continue;
                }
                PDBHeader header = this.getPDBHeaderFromLine(line);
                if (this.filters.size() != 0) {
                    throw new UnsupportedOperationException("can not sort PDBHeaders yet");
                }
                this.filteredPDBs.add(header);
                line = indexReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filterIterator = this.filteredPDBs.iterator();
        this.filtersApplied = true;
    }

    private String nullCheck(String str) {
        if (str.equals("null")) {
            str = null;
        }
        return str;
    }

    private PDBHeader getPDBHeaderFromLine(String line) {
        PDBHeader header = new PDBHeader();
        String[] spl = line.split("\t");
        if (spl.length != 9) {
            System.err.println("nr tabs length does not match expected length 9 (is " + spl.length + ")! " + line);
        }
        header.setIdCode(spl[0]);
        header.setTechnique(this.nullCheck(spl[2]));
        try {
            float resolution = Float.parseFloat(spl[3]);
            header.setResolution(resolution);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            Date dep = dateFormat.parse(spl[4]);
            header.setDepDate(dep);
            Date mod = dateFormat.parse(spl[5]);
            header.setModDate(mod);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        header.setTitle(this.nullCheck(spl[6]));
        header.setClassification(this.nullCheck(spl[7]));
        return header;
    }

    @Override
    public List<PDBHeader> getAll() {
        if (!this.filtersApplied) {
            this.applyFilters();
        }
        throw new UnsupportedOperationException("can not get all PDBHeaders yet");
    }

    @Override
    public PDBHeader getPDBHeader(String pdbId) {
        for (PDBHeader header : this.filteredPDBs) {
            String id = header.getIdCode();
            if (!pdbId.equals(id)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Structure getStructure(String pdbId) {
        Structure s = null;
        try {
            s = this.reader.getStructureById(pdbId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    @Override
    public boolean hasNext() {
        if (!this.filtersApplied) {
            this.applyFilters();
        }
        return this.filterIterator.hasNext();
    }

    @Override
    public Structure next() {
        if (!this.filtersApplied) {
            this.applyFilters();
        }
        PDBHeader header = this.filterIterator.next();
        String pdbId = header.getIdCode();
        Structure s = null;
        try {
            System.out.println("flatfileinstallation : next:" + pdbId + " " + this.getFilePath());
            s = this.reader.getStructureById(pdbId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }
}

