/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.biojava.bio.structure.io.MMCIFFileReader;
import org.biojava.bio.structure.server.FlatFileInstallation;
import org.biojava.bio.structure.server.PrepareIndexFile;

public class PrepareMMcifIndexFile
extends PrepareIndexFile {
    public static Logger logger = Logger.getLogger("org.biojava.bio.structure");

    public File[] getAllMMcif(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("path is not a directory " + dir);
        }
        String[] all = dir.list();
        ArrayList<File> pdbFiles = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            String file = all[i];
            File f2 = new File(dir.getAbsolutePath() + "/" + file);
            if (f2.isDirectory()) {
                File[] subPDBs = this.getAllMMcif(f2);
                logger.info("got " + subPDBs.length + " files from subdir " + f2);
                for (File file2 : subPDBs) {
                    if (pdbFiles.contains(file2)) continue;
                    pdbFiles.add(file2);
                }
                continue;
            }
            if (!file.endsWith(".cif.gz") && !file.endsWith(".mmcif.gz")) continue;
            pdbFiles.add(new File(dir + File.separator + file));
        }
        return pdbFiles.toArray(new File[pdbFiles.size()]);
    }

    @Override
    public void prepareIndexFileForInstallation(FlatFileInstallation installation) throws FileNotFoundException, IOException {
        File[] pdbfiles = this.getAllMMcif(installation.getFilePath());
        logger.info("found " + pdbfiles.length + " mmcif files");
        this.createMMcifInfoList(pdbfiles, installation.getPDBInfoFile(), installation.getChainInfoFile());
    }

    public void createMMcifInfoList(File[] pdbfiles, File outputFile, File chainInfoFile) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        PrintStream p = new PrintStream(out);
        PrintWriter pdbWriter = new PrintWriter(p);
        FileOutputStream cout = new FileOutputStream(chainInfoFile);
        PrintStream pc = new PrintStream(cout);
        PrintWriter chainWriter = new PrintWriter(pc);
        MMCIFFileReader pdbreader = new MMCIFFileReader();
        this.logPDBInfoFile(pdbWriter, chainWriter, pdbreader, pdbfiles);
    }
}

