/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.util.Equals;
import org.biojava3.core.util.Hashcoder;

public abstract class AbstractCompoundSet<C extends Compound>
implements CompoundSet<C> {
    private Map<CharSequence, C> charSeqToCompound = new HashMap<CharSequence, C>();
    private int maxCompoundCharSequenceLength = -1;
    private Boolean compoundStringLengthEqual = null;
    Map<C, Set<C>> equivalentsMap = new HashMap<C, Set<C>>();

    protected void addCompound(C compound, C lowerCasedCompound, Iterable<C> equivalents) {
        this.addCompound(compound);
        this.addCompound(lowerCasedCompound);
        this.addEquivalent(compound, lowerCasedCompound);
        this.addEquivalent(lowerCasedCompound, compound);
        for (Compound equivalent : equivalents) {
            this.addEquivalent(compound, equivalent);
            this.addEquivalent(equivalent, compound);
            this.addEquivalent(lowerCasedCompound, equivalent);
            this.addEquivalent(equivalent, lowerCasedCompound);
        }
    }

    protected void addCompound(C compound, C lowerCasedCompound, C ... equivalents) {
        ArrayList<C> equiv = new ArrayList<C>(equivalents.length);
        equiv.addAll(Arrays.asList(equivalents));
        this.addCompound(compound, lowerCasedCompound, (Iterable<C>)equiv);
    }

    protected void addEquivalent(C compound, C equivalent) {
        Set<C> s = this.equivalentsMap.get(compound);
        if (s == null) {
            s = new HashSet<C>();
            this.equivalentsMap.put(compound, s);
        }
        s.add(equivalent);
    }

    protected void addCompound(C compound) {
        this.charSeqToCompound.put(compound.toString(), compound);
        this.maxCompoundCharSequenceLength = -1;
        this.compoundStringLengthEqual = null;
    }

    @Override
    public String getStringForCompound(C compound) {
        return compound.toString();
    }

    @Override
    public C getCompoundForString(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Given a null CharSequence to process");
        }
        if (string2.length() == 0) {
            return null;
        }
        if (string2.length() > this.getMaxSingleCompoundStringLength()) {
            throw new IllegalArgumentException("CharSequence supplied is too long.");
        }
        return (C)((Compound)this.charSeqToCompound.get(string2));
    }

    @Override
    public int getMaxSingleCompoundStringLength() {
        if (this.maxCompoundCharSequenceLength == -1) {
            for (Compound compound : this.charSeqToCompound.values()) {
                int size2 = this.getStringForCompound(compound).length();
                if (size2 <= this.maxCompoundCharSequenceLength) continue;
                this.maxCompoundCharSequenceLength = size2;
            }
        }
        return this.maxCompoundCharSequenceLength;
    }

    @Override
    public boolean isCompoundStringLengthEqual() {
        if (this.compoundStringLengthEqual == null) {
            int lastSize = -1;
            this.compoundStringLengthEqual = Boolean.TRUE;
            for (CharSequence c : this.charSeqToCompound.keySet()) {
                int size2 = c.length();
                if (lastSize != -1) {
                    lastSize = size2;
                    continue;
                }
                if (lastSize == size2) continue;
                this.compoundStringLengthEqual = Boolean.FALSE;
                break;
            }
        }
        return this.compoundStringLengthEqual;
    }

    @Override
    public boolean hasCompound(C compound) {
        C retrievedCompound = this.getCompoundForString(compound.toString());
        return retrievedCompound != null;
    }

    @Override
    public boolean compoundsEquivalent(C compoundOne, C compoundTwo) {
        this.assertCompound(compoundOne);
        this.assertCompound(compoundTwo);
        return this.equivalentsMap.get(compoundOne).contains(compoundTwo);
    }

    @Override
    public Set<C> getEquivalentCompounds(C compound) {
        return this.equivalentsMap.get(compound);
    }

    public boolean compoundsEqual(C compoundOne, C compoundTwo) {
        this.assertCompound(compoundOne);
        this.assertCompound(compoundTwo);
        return compoundOne.equalsIgnoreCase((Compound)compoundTwo);
    }

    @Override
    public void verifySequence(Sequence<C> sequence2) throws CompoundNotFoundError {
        for (Compound compound : sequence2) {
            this.assertCompound(compound);
        }
    }

    @Override
    public List<C> getAllCompounds() {
        return new ArrayList<C>(this.charSeqToCompound.values());
    }

    private void assertCompound(C compound) {
        boolean okay = this.hasCompound(compound);
        if (!okay) {
            throw new CompoundNotFoundError((CharSequence)("The CompoundSet " + this.getClass().getSimpleName() + " knows nothing about the compound " + compound));
        }
    }

    @Override
    public boolean isComplementable() {
        return false;
    }

    public int hashCode() {
        int s = 9;
        s = Hashcoder.hash(s, this.charSeqToCompound);
        s = Hashcoder.hash(s, this.equivalentsMap);
        return s;
    }

    public boolean equals(Object o) {
        if (Equals.classEqual(this, o)) {
            AbstractCompoundSet that = (AbstractCompoundSet)o;
            return Equals.equal(this.charSeqToCompound, that.charSeqToCompound) && Equals.equal(this.equivalentsMap, that.equivalentsMap);
        }
        return false;
    }
}

