/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.nextProt.NextProtParser;
import org.snpeff.nextProt.NextProtParserV2;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Timer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NextProtDb {
    public static final double HIGHLY_CONSERVED_AA_PERCENT = 0.99;
    public static final int HIGHLY_CONSERVED_AA_COUNT = 30;
    boolean debug;
    boolean verbose;
    String trIdFile;
    String xmlDirName;
    Markers markers;
    Config config;
    Genome genome;
    int aaErrors;

    public NextProtDb(String xmlDirName, Config config) {
        this.config = config;
        this.xmlDirName = xmlDirName;
        this.markers = new Markers();
    }

    protected void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    int nextProtXmlVersion(Node doc) {
        Node nextProtNode = doc.getFirstChild();
        String nextProtNodeName = nextProtNode.getNodeName();
        if (nextProtNodeName.equals("nextprotExport")) {
            return 1;
        }
        if (nextProtNodeName.equals("nextprot-export")) {
            return 2;
        }
        throw new RuntimeException("Unrecognized nextprot version: Node name '" + nextProtNodeName + "'");
    }

    public boolean parse() {
        String[] files;
        this.genome = this.config.getGenome();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        if (this.verbose) {
            Timer.showStdErr("Reading NextProt files from directory '" + this.xmlDirName + "'");
        }
        if ((files = new File(this.xmlDirName).list()) != null) {
            for (String xmlFileName : files) {
                if (this.verbose) {
                    Timer.showStdErr("\tNextProt file '" + xmlFileName + "'");
                }
                if (!xmlFileName.endsWith(".xml.gz") && !xmlFileName.endsWith(".xml")) continue;
                String path = this.xmlDirName + "/" + xmlFileName;
                this.parse(path);
            }
        } else {
            this.fatalError("No XML files found in directory '" + this.xmlDirName + "'");
        }
        return true;
    }

    void parse(Node doc) {
        NextProtParser nextProtParser;
        int xmlVersion = this.nextProtXmlVersion(doc);
        if (this.verbose) {
            Timer.showStdErr("NextProt XML version:" + xmlVersion);
        }
        switch (xmlVersion) {
            case 1: {
                nextProtParser = new NextProtParser(this.config);
                break;
            }
            case 2: {
                nextProtParser = new NextProtParserV2(this.config);
                break;
            }
            default: {
                throw new RuntimeException("Unknown NextProt XML version " + xmlVersion);
            }
        }
        nextProtParser.setVerbose(this.verbose);
        nextProtParser.setDebug(this.debug);
        nextProtParser.setTrIdFile(this.trIdFile);
        nextProtParser.parse(doc);
        this.markers.add(nextProtParser.getMarkers());
    }

    void parse(String xmlFileName) {
        try {
            if (this.verbose) {
                Timer.showStdErr("Reading file:" + xmlFileName);
            }
            File xmlFile = new File(xmlFileName);
            Document doc = null;
            doc = xmlFileName.endsWith(".gz") ? DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new GZIPInputStream(new FileInputStream(xmlFile))) : DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFile);
            if (this.verbose) {
                Timer.showStdErr("Normalizing XML document");
            }
            doc.getDocumentElement().normalize();
            this.parse(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveDatabase() {
        String nextProtBinFile = this.config.getDirDataGenomeVersion() + "/nextProt.bin";
        if (this.verbose) {
            Timer.showStdErr("Saving database to file '" + nextProtBinFile + "'");
        }
        HashSet<Chromosome> chromos = new HashSet<Chromosome>();
        for (Marker m : this.markers) {
            chromos.add(m.getChromosome());
        }
        Markers markersToSave = new Markers();
        markersToSave.add(this.genome);
        for (Chromosome chr : chromos) {
            markersToSave.add(chr);
        }
        for (Marker m : this.markers) {
            markersToSave.add(m);
        }
        markersToSave.save(nextProtBinFile);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrIdFile(String trIdFile) {
        this.trIdFile = trIdFile;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    String vcfSafe(String str) {
        return str.trim().replaceAll("(,|;|=| |\t)+", "_");
    }
}

