/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.junit.Test;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerUtil;
import org.snpeff.interval.Markers;
import org.snpeff.util.Gpr;
import org.snpeff.util.Tuple;

public class TestCasesMarkerUtils {
    int maxLen = 100;
    int minLen = 1;
    int maxGap = 100;
    int minGap = 50;
    boolean verbose = false;
    boolean compareCdsTestsEnable = false;
    Random rand;
    Genome genome;

    public TestCasesMarkerUtils() {
        this.initRand();
        String genomeName = "testCaseHg";
        this.genome = new Genome(genomeName);
        for (int i = 1; i < 22; ++i) {
            this.genome.add(new Chromosome(this.genome, 0, 0, "" + i));
        }
        this.genome.add(new Chromosome(this.genome, 0, 0, "X"));
        this.genome.add(new Chromosome(this.genome, 0, 0, "Y"));
    }

    Tuple<Markers, Markers> createMarkers(Chromosome chr, int numMarkers) {
        Markers markers = new Markers();
        Markers markersCollapsed = new Markers();
        int start = 0;
        int startPrev = -1;
        int end = 0;
        int gap = 0;
        Marker m = null;
        Marker mcol = null;
        for (int i = 0; i < numMarkers; ++i) {
            int size2 = this.rand.nextInt(this.maxLen) + this.minLen;
            end = start + size2;
            if (startPrev < 0) {
                startPrev = start;
            }
            m = new Marker(chr, start, end, false, "");
            markers.add(m);
            gap = this.rand.nextInt(this.maxGap);
            mcol = new Marker(chr, startPrev, end, false, "");
            if (gap <= this.minGap) {
                gap = 1;
            } else {
                markersCollapsed.add(mcol);
                mcol = null;
                startPrev = -1;
            }
            start = end + gap;
        }
        if (mcol != null) {
            markersCollapsed.add(mcol);
        }
        return new Tuple<Markers, Markers>(markers, markersCollapsed);
    }

    void initRand() {
        this.rand = new Random(20121115L);
    }

    String markers2string(Markers markers) {
        StringBuilder sb = new StringBuilder();
        int prevEnd = -1;
        markers.sort(false, false);
        for (Marker m : markers) {
            int i;
            if (prevEnd >= 0) {
                for (i = prevEnd; i < m.getStart(); ++i) {
                    sb.append('-');
                }
            }
            for (i = m.getStart(); i <= m.getEnd(); ++i) {
                sb.append('M');
            }
            prevEnd = m.getEnd() + 1;
        }
        return sb.toString();
    }

    @Test
    public void test_collapseZeroGap() {
        Gpr.debug("Test");
        this.initRand();
        int numMarkers = 20;
        Chromosome chr = this.genome.getChromosome("1");
        for (int num = 1; num < 1000; ++num) {
            Tuple<Markers, Markers> tupleMarkers = this.createMarkers(chr, numMarkers);
            Markers markersOri = (Markers)tupleMarkers.first;
            Markers markersCollapsedOri = (Markers)tupleMarkers.second;
            String mStr = this.markers2string(markersOri);
            String mColOriStr = this.markers2string(markersCollapsedOri);
            if (this.verbose) {
                Gpr.debug("Iteration : " + num + "\n\tMarkers           : " + mStr + "\n\tMarkers collapsed : " + mColOriStr);
            }
            if (!mStr.equals(mColOriStr)) {
                System.err.println("Markers : ");
                for (Marker m : markersOri) {
                    System.err.println(m);
                }
                System.err.println("Markers collapsed: ");
                for (Marker m : markersCollapsedOri) {
                    System.err.println(m);
                }
                throw new RuntimeException("Error creating markers! Markers and collapsed marker do not match!\n\t" + mStr + "\n\t" + mColOriStr);
            }
            Map<Marker, Marker> collapse = MarkerUtil.collapseZeroGap(markersOri);
            HashSet<Marker> collapsed = new HashSet<Marker>();
            collapsed.addAll(collapse.values());
            Markers markers = new Markers();
            markers.addAll((Collection<? extends Marker>)collapsed);
            String mColStr = this.markers2string(markers);
            if (mColStr.equals(mStr)) continue;
            Gpr.debug("Error checing markers! Markers and collapsed marker do not match!\n\t" + mStr + "\n\t" + mColStr);
            System.err.println("Markers : ");
            for (Marker m : markersOri) {
                System.err.println(m);
            }
            System.err.println("Markers collapsed: ");
            markers = new Markers();
            markers.addAll((Collection<? extends Marker>)collapse.keySet());
            Markers keySorted = markers.sort(false, false);
            for (Marker mkey : keySorted) {
                System.err.println(mkey + "\t->\t" + collapse.get(mkey));
            }
            throw new RuntimeException("Error checing markers! Markers and collapsed marker do not match!\n\t" + mStr + "\n\t" + mColStr);
        }
    }
}

