/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import org.snpeff.stats.GenotypeStats;
import org.snpeff.stats.IntStats;
import org.snpeff.stats.SamplingStats;
import org.snpeff.stats.TsTvStats;
import org.snpeff.vcf.VcfEntry;

public class VcfStats
implements SamplingStats<VcfEntry> {
    IntStats qualityStats = new IntStats();
    TsTvStats tsTvStats = new TsTvStats();
    TsTvStats tsTvStatsKnown = new TsTvStats();
    GenotypeStats genotypeStats = new GenotypeStats();
    int countMultiallelic = 0;

    public int getCountMultiallelic() {
        return this.countMultiallelic;
    }

    public GenotypeStats getGenotypeStats() {
        return this.genotypeStats;
    }

    public IntStats getQualityStats() {
        return this.qualityStats;
    }

    public String getQualityStatsHistoUrl() {
        return this.qualityStats.toStringPlot("Quality histogram", "Quality", true);
    }

    public TsTvStats getTsTvStats() {
        return this.tsTvStats;
    }

    public TsTvStats getTsTvStatsKnown() {
        return this.tsTvStatsKnown;
    }

    @Override
    public boolean hasData() {
        return this.tsTvStats.hasData() || this.genotypeStats.hasData();
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (!vcfEntry.getId().isEmpty()) {
            this.tsTvStatsKnown.sample(vcfEntry);
        }
        this.tsTvStats.sample(vcfEntry);
        if (vcfEntry.hasQuality()) {
            this.qualityStats.sample((int)vcfEntry.getQuality());
        }
        this.genotypeStats.sample(vcfEntry);
        if (vcfEntry.isMultiallelic()) {
            ++this.countMultiallelic;
        }
    }
}

