/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import org.snpeff.fileIterator.MarkerFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Motif;
import org.snpeff.motif.Jaspar;

public class MotifFileIterator
extends MarkerFileIterator<Motif> {
    public static final int GFF_OFFSET = 1;
    Jaspar jaspar;

    public MotifFileIterator(String fileName, Genome genome, Jaspar jaspar) {
        super(fileName, genome, 1);
        this.jaspar = jaspar;
    }

    @Override
    protected Motif readNext() {
        try {
            while (this.ready()) {
                String[] infos;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int start = this.parsePosition(fields[3]);
                int end = this.parsePosition(fields[4]);
                String id = "line_" + this.lineNum;
                String strandStr = fields[6];
                boolean strandMinus = strandStr.equals("-");
                String info = fields[8];
                String name = "";
                String pwmId = "";
                for (String nv : infos = info.split(";")) {
                    String[] nameValue = nv.split("=");
                    if (nameValue.length <= 0) continue;
                    String attr = nameValue[0].trim();
                    String val = nameValue[1].trim();
                    if (attr.equals("Name")) {
                        name = val;
                        String[] names = name.split(":");
                        name = names[0];
                        pwmId = names[names.length - 1];
                        continue;
                    }
                    if (attr.equals("binding_matrix")) {
                        pwmId = val;
                        continue;
                    }
                    if (!attr.equals("motif_feature_type")) continue;
                    name = val;
                }
                if (name.isEmpty()) {
                    if (!this.verbose) continue;
                    System.err.println("Warning: Name not found, line " + this.lineNum + "\t" + this.line);
                    continue;
                }
                if (pwmId.isEmpty()) {
                    if (!this.verbose) continue;
                    System.err.println("Warning: PWM ID not found, line " + this.lineNum + "\t" + this.line);
                    continue;
                }
                if (this.jaspar.getPwm(pwmId) == null) {
                    if (!this.verbose) continue;
                    System.err.println("Warning: PWM '" + pwmId + "' not found, line " + this.lineNum + "\t" + this.line);
                    continue;
                }
                Motif motif = new Motif(chromo, start, end, strandMinus, id, name, pwmId);
                motif.setPwm(this.jaspar.getPwm(pwmId));
                return motif;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

