/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary.io;

import org.biojava.bio.structure.quaternary.io.BioUnitDataProvider;

public class BioUnitDataProviderFactory {
    public static final String mmcifProviderClassName = "org.biojava.bio.structure.quaternary.io.MmCifBiolAssemblyProvider";
    public static final String remoteProviderClassName = "org.biojava.bio.structure.quaternary.io.RemoteBioUnitDataProvider";
    public static final String pdbProviderClassName = "org.biojava.bio.structure.quaternary.io.PDBBioUnitDataProvider";
    public static final String fileBasedProviderClassName = "org.biojava.bio.structure.quaternary.io.FileBasedPDBBioUnitDataProvider";
    public static String DEFAULT_PROVIDER_CLASSNAME;
    private static String providerClassName;

    private BioUnitDataProviderFactory() {
    }

    public static BioUnitDataProvider getBioUnitDataProvider() {
        try {
            Class<?> cls = Class.forName(providerClassName);
            return (BioUnitDataProvider)cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setBioUnitDataProvider(String className) {
        try {
            Class<?> cls = Class.forName(providerClassName);
            Class<?> interfaceClass = Class.forName("org.biojava.bio.structure.quaternary.io.BioUnitDataProvider");
            Class<?>[] ifs = cls.getInterfaces();
            boolean found = false;
            for (Class<?> c : ifs) {
                if (!c.equals(interfaceClass)) continue;
                found = true;
                break;
            }
            if (!found) {
                System.err.println("The provided class " + className + " does not implement the correct interface!");
                return;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        providerClassName = className;
    }

    static {
        providerClassName = DEFAULT_PROVIDER_CLASSNAME = pdbProviderClassName;
    }
}

