/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.Collections;
import java.util.Iterator;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.KeyValue;

public class Custom
extends Marker
implements Iterable<KeyValue<String, String>> {
    private static final long serialVersionUID = -6843535415295857726L;
    String label;
    double score = Double.NaN;

    public Custom() {
        this.type = EffectType.CUSTOM;
        this.label = "";
    }

    public Custom(Marker parent, int start, int end, boolean strandMinus, String id, String label) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.CUSTOM;
        this.label = label;
        if (label == null || label.isEmpty()) {
            label = id;
        }
    }

    @Override
    public Custom cloneShallow() {
        Custom clone2 = (Custom)super.cloneShallow();
        clone2.label = this.label;
        clone2.score = this.score;
        return clone2;
    }

    public String getLabel() {
        return this.label;
    }

    public double getScore() {
        return this.score;
    }

    public boolean hasAnnotations() {
        return false;
    }

    @Override
    public Iterator<KeyValue<String, String>> iterator() {
        return Collections.emptySet().iterator();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName());
        sb.append("\t");
        sb.append(this.start);
        sb.append("-");
        sb.append(this.end);
        sb.append(" ");
        sb.append((Object)this.type);
        sb.append(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
        if (this.hasAnnotations()) {
            for (KeyValue<String, String> kv : this) {
                sb.append((String)kv.key + "=" + (String)kv.value + ";");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects changeEffecs) {
        if (!this.intersects(variant)) {
            return false;
        }
        changeEffecs.add(variant, this, EffectType.CUSTOM, this.label);
        return true;
    }
}

