/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationCanonical
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String geneId = "APOBEC3H";
        String trId = "NM_001166003.2";
        String[] args = new String[]{"-canon", "testHg19Chr22", "tests/empty.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        cmdEff.load();
        Gene gene = cmdEff.getConfig().getSnpEffectPredictor().getGene(geneId);
        Transcript tr = (Transcript)gene.subIntervals().iterator().next();
        Assert.assertEquals("Expecting transcript ID does not match", trId, tr.getId());
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String geneId = "APOBEC3H";
        String trId = "NM_181773.4";
        String[] args = new String[]{"-canonList", "tests/canon_geneId2trId_test02.txt", "testHg19Chr22", "tests/empty.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        cmdEff.load();
        Gene gene = cmdEff.getConfig().getSnpEffectPredictor().getGene(geneId);
        Transcript tr = (Transcript)gene.subIntervals().iterator().next();
        Assert.assertEquals("Expecting transcript ID does not match", trId, tr.getId());
    }
}

