/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.util.HashMap;

public enum AlgorithmType {
    DSA("1.2.840.10040.4.1"),
    RSA("1.2.840.113549.1.1.1");

    private static final HashMap<String, AlgorithmType> OID_MAP;
    private final String oid;

    private AlgorithmType(String string2) {
        this.oid = string2;
    }

    public static AlgorithmType valueOfOid(String string) {
        return OID_MAP.get(string);
    }

    public static String toString(String string) {
        AlgorithmType algorithmType = AlgorithmType.valueOfOid(string);
        if (algorithmType != null) {
            return algorithmType.toString();
        }
        return string;
    }

    static {
        OID_MAP = new HashMap();
        for (AlgorithmType algorithmType : AlgorithmType.values()) {
            OID_MAP.put(algorithmType.oid, algorithmType);
        }
    }
}

