/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import net.sf.portecle.FPortecle;
import net.sf.portecle.StringUtil;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.DigestType;

public final class DigestUtil {
    private DigestUtil() {
    }

    public static String getMessageDigest(byte[] byArray, DigestType digestType) throws CryptoException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(digestType.name());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoCreateDigest.exception.message"), new Object[]{digestType}), noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        StringBuilder stringBuilder = StringUtil.toHex(byArray2, 2, ":");
        return stringBuilder.toString();
    }
}

