/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import net.sf.portecle.FPortecle;

public final class DesktopUtil {
    private static final Desktop DESKTOP = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;

    private DesktopUtil() {
    }

    public static void browse(Component component, URI uRI) {
        if (DESKTOP != null) {
            try {
                DESKTOP.browse(uRI);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JOptionPane.showMessageDialog(component, MessageFormat.format(FPortecle.RB.getString("FPortecle.NoLaunchBrowser.message"), uRI), FPortecle.RB.getString("FPortecle.Title"), 1);
    }

    public static void mail(Component component, String string) {
        if (DESKTOP != null) {
            try {
                DESKTOP.mail(new URI("mailto:" + URLEncoder.encode(string, StandardCharsets.ISO_8859_1.name())));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JOptionPane.showMessageDialog(component, MessageFormat.format(FPortecle.RB.getString("FPortecle.NoLaunchEmail.message"), string), FPortecle.RB.getString("FPortecle.Title"), 1);
    }
}

